import sys
import os
import platform
import ac
import acsys 
import threading
import time
import csv
import math

if not hasattr(sys, 'argv'):
    sys.argv  = ['']
try:
    if platform.architecture()[0] == "64bit":
        sysdir = "stdlib64"
    else:
        sysdir = "stdlib"
    sys.path.insert(0, os.path.join(os.path.dirname(__file__), sysdir))
    os.environ['PATH'] = os.environ['PATH'] + ";."
except Exception as e:
    ac.log("TrackAttackPlugin: Error importing libraries: %s" % e)

from sim_info import info

TEMP_FILE_NAME = "trackAttackTempLog.csv.gz"

class TrackAttackExport:
    # Windows
    mainWindow=0
    labelWindow=0

    # Miscellaneous
    currentDate=0
    sessionStartTime=0

    # File
    dataFile=0
    dataFileWriter=0
    firstWrite=True
    wasInPitLast=1
    fileLock=threading.RLock()

    # Lap Times
    lastLapTime=0
    currentLapTime=0
    lapTimeList=[]

# The trackAttack Object
trackAttack = TrackAttackExport()

def acMain(ac_version):
    ac.log("Track Attack plugin waking up")

    global trackAttack

    # Window Assembly ======================================================================================
    trackAttack.mainWindow = ac.newApp("Track Attack Data Export Plugin")
    ac.setIconPosition(trackAttack.mainWindow, 0, -10000)
    
    # Main Window
    ac.setSize(trackAttack.mainWindow, 128, 128)
    ac.setTitle(trackAttack.mainWindow,'')
    ac.setBackgroundTexture(trackAttack.mainWindow,os.getcwd()+"\\apps\\python\\trackAttackPlugin\\Working.png")
    ac.setVisible(trackAttack.mainWindow,1)

    # label
    trackAttack.labelWindow = ac.addLabel(trackAttack.mainWindow, 'Track Attack Plugin')
    ac.setPosition(trackAttack.labelWindow,  0, -20)
  
    # Date and Time
    trackAttack.currentDate = time.strftime("%m/%d/%y", time.localtime())
    trackAttack.sessionStartTime = time.strftime("%H:%M:%S", time.localtime())

    # File to Write
    prepareFileToWrite()
    ac.log("Track Attack plugin initialized")
    return "trackAttackPlugin"

def prepareFileToWrite():
    global trackAttack

    ac.log("TA logging to {}".format(TEMP_FILE_NAME))

    import gzip
    trackAttack.fileLock.acquire()
    try:
        trackAttack.dataFile = gzip.open(TEMP_FILE_NAME, 'wt')
        trackAttack.dataFileWriter = csv.writer(trackAttack.dataFile, delimiter=',', quotechar='"', quoting=csv.QUOTE_ALL)
        trackAttack.firstWrite = True
    finally:
        trackAttack.fileLock.release()

def writeFileMetaData(dataFileWriter):
    dataFileWriter.writerow(["Format","Assetto Corsa CSV File"])
    dataFileWriter.writerow(["Data Source","Assetto Corsa"])
    dataFileWriter.writerow(["Date",trackAttack.currentDate])
    dataFileWriter.writerow(["Time",trackAttack.sessionStartTime])
    dataFileWriter.writerow(["smVersion",info.static._smVersion])
    dataFileWriter.writerow(["acVersion",info.static._acVersion])
    dataFileWriter.writerow(["numberOfSessions",info.static.numberOfSessions])
    dataFileWriter.writerow(["numCars",info.static.numCars])
    dataFileWriter.writerow(["carModel",info.static.carModel])
    dataFileWriter.writerow(["track",info.static.track])
    dataFileWriter.writerow(["playerName",info.static.playerName])
    dataFileWriter.writerow(["playerNick",info.static.playerNick])
    dataFileWriter.writerow(["playerSurname",info.static.playerSurname])
    dataFileWriter.writerow(["sectorCount",info.static.sectorCount])

def writeRaceDataHeader(dataFileWriter):
    dataFileWriter.writerow([
     
            #Physics Info
            "accG lat",
            "accG lon",
            "accG vert",
            "brake",
            "camberRAD fl",
            "camberRAD fr",
            "camberRAD rl",
            "camberRAD rr",
            "carDamage1",
            "carDamage2",
            "carDamage3",
            "carDamage4",
            "carDamage5",
            "cgHeight",
            "drs",
            "tc",
            "fuel",
            "gas",
            "gear",
            "numberOfTyresOut",
            "packetId",
            "heading",
            "pitch",
            "roll",
            "rpms",
            "speedKmh",
            "steerAngle",
            "suspensionTravel fl",
            "suspensionTravel fr",
            "suspensionTravel bl",
            "suspensionTravel br",
            "tyreCoreTemperature fl",
            "tyreCoreTemperature fr",
            "tyreCoreTemperature bl",
            "tyreCoreTemperature br",
            "tyreDirtyLevel fl",
            "tyreDirtyLevel fr",
            "tyreDirtyLevel bl",
            "tyreDirtyLevel br",
            "tyreWear fl",
            "tyreWear fr",
            "tyreWear bl",
            "tyreWear br",
            "velocity x",
            "velocity y",
            "velocity z",
            "wheelAngularSpeed fl",
            "wheelAngularSpeed fr",
            "wheelAngularSpeed bl",
            "wheelAngularSpeed br",
            "wheelLoad fl",
            "wheelLoad fr",
            "wheelLoad bl",
            "wheelLoad br",
            "wheelSlip fl",
            "wheelSlip fr",
            "wheelSlip bl",
            "wheelSlip br",
            "wheelsPressure fl",
            "wheelsPressure fr",
            "wheelsPressure bl",
            "wheelsPressure br",

            #Graphics Info
            "packetId",
            "status",
            "session",
            "completedLaps",
            "position",
            "currentTime",
            "iCurrentTime",
            "iLastTime",
            "iBestTime",
            "sessionTimeLeft",
            "distanceTraveled",
            "isInPit",
            "currentSectorIndex",
            "lastSectorTime",
            "numberOfLaps",
            "replayTimeMultiplier",
            "normalizedCarPosition",
            "carCoordinates x",
            "carCoordinates y",
            "carCoordinates z"
    ])

def writeHeaderUnits(dataFileWriter):
    dataFileWriter.writerow([
            
            #Physics Info
            "g",
            "g",
            "g",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "rpm",
            "km/h",
            "deg",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",
            "",

            #Graphics Info
            "",
            "",
            "",
            "",
            "",
            "sec",
            "",
            "",
            "",
            "",
            "m",
            "",
            "",
            "",
            "",
            "",
            "",
            "m",
            "m",
            "m"
     ])

def writeRaceData(dataFileWriter):
    dataFileWriter.writerow([
       
            info.physics.accG[0],
            info.physics.accG[1],
            info.physics.accG[2],
            info.physics.brake,
            info.physics.camberRAD[0],
            info.physics.camberRAD[1],
            info.physics.camberRAD[2],
            info.physics.camberRAD[3],
            info.physics.carDamage[0],
            info.physics.carDamage[1],
            info.physics.carDamage[2],
            info.physics.carDamage[3],
            info.physics.carDamage[4],
            info.physics.cgHeight,
            info.physics.drs,
            info.physics.tc,
            info.physics.fuel,
            info.physics.gas,
            info.physics.gear,
            info.physics.numberOfTyresOut,
            info.physics.packetId,
            info.physics.heading,
            info.physics.pitch,
            info.physics.roll,
            info.physics.rpms,
            info.physics.speedKmh,
            info.physics.steerAngle,
            info.physics.suspensionTravel[0],
            info.physics.suspensionTravel[1],
            info.physics.suspensionTravel[2],
            info.physics.suspensionTravel[3],
            info.physics.tyreCoreTemperature[0],
            info.physics.tyreCoreTemperature[1],
            info.physics.tyreCoreTemperature[2],
            info.physics.tyreCoreTemperature[3],
            info.physics.tyreDirtyLevel[0],
            info.physics.tyreDirtyLevel[1],
            info.physics.tyreDirtyLevel[2],
            info.physics.tyreDirtyLevel[3],
            info.physics.tyreWear[0],
            info.physics.tyreWear[1],
            info.physics.tyreWear[2],
            info.physics.tyreWear[3],
            info.physics.velocity[0],
            info.physics.velocity[1],
            info.physics.velocity[2],
            info.physics.wheelAngularSpeed[0],
            info.physics.wheelAngularSpeed[1],
            info.physics.wheelAngularSpeed[2],
            info.physics.wheelAngularSpeed[3],
            info.physics.wheelLoad[0],
            info.physics.wheelLoad[1],
            info.physics.wheelLoad[2],
            info.physics.wheelLoad[3],
            info.physics.wheelSlip[0],
            info.physics.wheelSlip[1],
            info.physics.wheelSlip[2],
            info.physics.wheelSlip[3],
            info.physics.wheelsPressure[0],
            info.physics.wheelsPressure[1],
            info.physics.wheelsPressure[2],
            info.physics.wheelsPressure[3],
        
            info.graphics.packetId,
            info.graphics.status,
            info.graphics.session,
            info.graphics.completedLaps,
            info.graphics.position,
            info.graphics.currentTime,
            info.graphics.iCurrentTime/1000,
            info.graphics.iLastTime/1000,
            info.graphics.iBestTime,
            info.graphics.sessionTimeLeft,
            info.graphics.distanceTraveled,
            info.graphics.isInPit,
            info.graphics.currentSectorIndex,
            info.graphics.lastSectorTime,
            info.graphics.numberOfLaps,
            info.graphics.replayTimeMultiplier,
            info.graphics.normalizedCarPosition,
            info.graphics.carCoordinates[0],
            info.graphics.carCoordinates[1],
            info.graphics.carCoordinates[2]
    ])

def acUpdate(deltaT):
    try:
        global trackAttack

        if(trackAttack.dataFile.closed):
            return

        if(trackAttack.fileLock.acquire(False)):
            try:
                # don't record when carCoordinates are all 0 because then we will get weird GPS data.
                if(info.graphics.carCoordinates[0] == 0 and info.graphics.carCoordinates[1] == 0 and info.graphics.carCoordinates[2] == 0):
                    return

                if trackAttack.firstWrite:
                    writeFileMetaData(trackAttack.dataFileWriter)
                    trackAttack.dataFile.write("\r\n")
                    writeRaceDataHeader(trackAttack.dataFileWriter)
                    writeHeaderUnits(trackAttack.dataFileWriter)
                    trackAttack.dataFile.write("\r\n")
                    trackAttack.firstWrite = False

                writeRaceData(trackAttack.dataFileWriter)
                trackAttack.currentLapTime = info.graphics.iCurrentTime/1000
                if(trackAttack.lastLapTime != info.graphics.iLastTime/1000):
                    trackAttack.lastLapTime == info.graphics.iLastTime/1000
                    try:
                        trackAttack.lapTimeList.index(info.graphics.iLastTime/1000)
                    except ValueError:
                        trackAttack.lapTimeList.append(info.graphics.iLastTime/1000)
                
                if(trackAttack.wasInPitLast == 0 and info.graphics.isInPit == 1):
                    closeTempFileWriteToOutput()
                    prepareFileToWrite()
                
                trackAttack.wasInPitLast = info.graphics.isInPit
            finally:
                trackAttack.fileLock.release()
    except Exception as e:
        import traceback
        ac.log(traceback.format_exc())
        raise
            

def closeTempFileWriteToOutput():
    global trackAttack
    trackAttack.fileLock.acquire()
    try:
        trackAttack.dataFile.close()

        import ctypes
        from ctypes.wintypes import MAX_PATH
        dll = ctypes.windll.shell32
        documentsFolderBuffer = ctypes.create_unicode_buffer(MAX_PATH + 1)
        if dll.SHGetSpecialFolderPathW(None, documentsFolderBuffer, 0x0005, False):
            outputDirectory = os.path.join(documentsFolderBuffer.value,'Track Attack Data')
        else:
            outputDirectory = os.path.join(os.getenv('USERPROFILE'),'Documents\\Track Attack Data')
             
        if not os.path.exists(outputDirectory):
            os.makedirs(outputDirectory)
        dataFilePath = "{}\\trackAttack_{}_{}.csv.gz".format(
            outputDirectory,
            info.static.track,
            time.strftime("%Y_%m_%d_%H_%M_%S", time.localtime()))
        ac.log("Moving data from %s to %s" % (TEMP_FILE_NAME, dataFilePath))
        import shutil
        shutil.move(TEMP_FILE_NAME, dataFilePath)
    finally:
        trackAttack.fileLock.release()

def acShutdown():
    closeTempFileWriteToOutput()
    ac.log("Track Attack plugin shutting down")
    return
